<?php
require_once __DIR__ . '/../config/db.php';

try {
    // Check if invoice_id column already exists
    $stmt = $pdo->query("SHOW COLUMNS FROM mpesa_transactions LIKE 'invoice_id'");
    $columnExists = $stmt->fetch();
    
    if (!$columnExists) {
        // Add invoice_id column to mpesa_transactions table
        $sql = "ALTER TABLE mpesa_transactions 
                ADD COLUMN invoice_id INT NULL AFTER customer_name,
                ADD INDEX idx_invoice_id (invoice_id)";
        
        $pdo->exec($sql);
        echo "✅ Added invoice_id column to mpesa_transactions table successfully!\n";
    } else {
        echo "ℹ️ invoice_id column already exists in mpesa_transactions table.\n";
    }
    
    // Check if mpesa_receipt column exists (some versions might use different name)
    $stmt = $pdo->query("SHOW COLUMNS FROM mpesa_transactions LIKE 'mpesa_receipt'");
    $receiptColumnExists = $stmt->fetch();
    
    if (!$receiptColumnExists) {
        // Add mpesa_receipt column if it doesn't exist
        $sql = "ALTER TABLE mpesa_transactions 
                ADD COLUMN mpesa_receipt VARCHAR(50) NULL AFTER mpesa_receipt_number";
        
        $pdo->exec($sql);
        echo "✅ Added mpesa_receipt column to mpesa_transactions table successfully!\n";
    } else {
        echo "ℹ️ mpesa_receipt column already exists in mpesa_transactions table.\n";
    }
    
    // Check if error_message column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM mpesa_transactions LIKE 'error_message'");
    $errorColumnExists = $stmt->fetch();
    
    if (!$errorColumnExists) {
        // Add error_message column if it doesn't exist
        $sql = "ALTER TABLE mpesa_transactions 
                ADD COLUMN error_message TEXT NULL AFTER result_description";
        
        $pdo->exec($sql);
        echo "✅ Added error_message column to mpesa_transactions table successfully!\n";
    } else {
        echo "ℹ️ error_message column already exists in mpesa_transactions table.\n";
    }

    // Show updated table structure
    $stmt = $pdo->query("DESCRIBE mpesa_transactions");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "📋 Updated table columns: " . implode(', ', $columns) . "\n";

} catch (PDOException $e) {
    echo "❌ Error updating mpesa_transactions table: " . $e->getMessage() . "\n";
    exit(1);
}

echo "🎉 Migration completed successfully!\n";
?> 